<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EstadoSolicitud extends Model 
{

    protected $table = 'estados_solicitudes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('solicitud_id', 'tipo_estado_solicitud_id', 'fecha', 'created_by', 'observations');
    protected $visible = array('solicitud_id', 'tipo_estado_solicitud_id', 'fecha', 'created_by', 'observations');

    public function solicitud()
    {
        return $this->belongsTo('Solicitud', 'solicitud_id')->withTrashed();
    }

    public function tipo_estado_solicitud()
    {
        return $this->belongsTo('TipoEstadoSolicitud', 'tipo_estado_solicitud_id')->withTrashed();
    }

}